/******************************************************************************/
class ToggleTrigger : BaseEvent
{
public:
            ToggleTrigger();
   virtual ~ToggleTrigger();
   
   virtual void create(Object &obj); 
   virtual void AfterCreate(      );
   
private:

   virtual void CallTriggeredAction();
   virtual void StopTriggeredAction();
   
   UID m_TriggerUID;
   EventTrigger* m_Trigger;
   
   bool m_TriggerActive;
};
/******************************************************************************/
ToggleTrigger::ToggleTrigger() : BaseEvent(), m_TriggerActive(false), m_Trigger(null)                         
{
   
}
ToggleTrigger::~ToggleTrigger()
{
   
}
/******************************************************************************/
void ToggleTrigger::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("ObjectActive")) m_TriggerActive = p.asBool();
   if(Param *p = obj.findParam("ObjectUID"))    m_TriggerUID    = p.asID();  
   
   super.create(obj); // Create the BaseEvent params too
}
/******************************************************************************/
void ToggleTrigger::AfterCreate()
{
   // Find the correct Trigger to work on. This has to be done here, because it's unreliable during create() (not all objects are loaded yet)
   REPA(eventTriggers)
      if(eventTriggers[i].id() == m_TriggerUID)
         m_Trigger = &eventTriggers[i]; 
         
   DEBUG_ASSERT(m_Trigger, "Trigger not found in scene");
}
/******************************************************************************/
// This method is called when the event was triggered, taking the delay into account
void ToggleTrigger::CallTriggeredAction()
{
   // Toggle the trigger
   m_Trigger->SetEnabled(m_TriggerActive);
}

// This method is called when the duration of the event has been reached
void ToggleTrigger::StopTriggeredAction()
{
   // If m_Duration is not -1, the trigger can enable/disable again after some time
   m_Trigger->SetEnabled(!m_TriggerActive);
}
/******************************************************************************/